﻿///
/// アーカイブの展開を行う ArchiveExtractor クラスの宣言を含むヘッダファイル。
///

#if       !defined(INCLUDED_SZ_ARCHIVE_EXTRACTOR)
#define            INCLUDED_SZ_ARCHIVE_EXTRACTOR

#if       !defined(INCLUDED_SZ_COMMON)
#include  <szCommon.hpp>
#endif // !defined(INCLUDED_SZ_COMMON)

#if       !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)
#include  <szForwardDeclarations.hpp>
#endif // !defined(INCLUDED_SZ_FORWARD_DECLARATIONS)

SZ_NS_BEG(szpp)

/// <summary>
/// アーカイブの展開を行うためのクラス。
/// </summary>
/// <todo>
/// - 部分的な展開に対応する→ワイルドカードで対応可能かも
/// - 抽象的なストリームを対象に展開→IInArchive のインターフェースを直接叩くように改良
/// </todo>
class SZ_SPEC ArchiveExtractor
{
public:

  /// <summary>
  /// アーカイブの展開処理クラスのコンストラクタ。
  /// </summary>
  /// <param name="handler">展開に用いるアーカイブハンドラのポインタ。</param>
  /// <param name="volume">展開するアーカイブボリューム。</param>
  //ArchiveExtractor(
  //  const ArchiveHandler *handler,
  //  ArchiveVolume *volume);

  /// <summary>
  /// デストラクタ。
  /// </summary>
  //~ArchiveExtractor();

  /// <summary>
  /// ファイルアーカイブをフォルダに簡易展開するための静的メソッドで、epolight のような簡易アプリが使用することを想定している。
  /// </summary>
  /// <param name="archivePath">展開するアーカイブファイルのパス文字列。</param>
  /// <param name="outputDir">展開先ディレクトリのパス文字列。ディレクトリ自動作成をするなら、自動作成するディレクトリ名も含んだ形で渡すこと。</param>
  /// <param name="password">アーカイブオープンまたは展開の際のパスワードの初期値があれば指定する。初期値がない場合は必ず NULL を与える（空文字列のポインタを渡すと初期値が空文字列という扱いになるので）。</param>
  /// <param name="openCallback">アーカイブを開く際の進行状況などを受け取るクライアントコールバックのポインタ</param>
  /// <param name="extractCallback">アーカイブを展開する際の進行状況などを受け取るクライアントコールバックのポインタ。</param>
  /// <param name="pwdCallback">ユーザーからパスワードを取得するためのクライアントコールバックのポインタ。</param>
  static void Extract(const szstring &archivePath,
                      const szstring &outputDir,
                      const szstring *password,
                      ArchiveOpenClientCallback *openCallback,
                      ArchiveFileExtractClientCallback *folderCallback,
                      GetPasswordClientCallback *pwdCallback);

private:

};

SZ_NS_END(szpp)

#endif // !defined(INCLUDED_SZ_ARCHIVE_EXTRACTOR)
